/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.eap.cloudsdk.client;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.sf.json.JSONObject;

public class Packet {
    public static final int FIXED_HEADER_SIZE = 4;
    public static final String DEFAULT_CHARSET = "UTF-8";
    private final short magicHeader = (short)-24142;
    private short length;
    private byte[] data;
    private final String charset = "UTF-8";

    public short getLength() {
        return this.length;
    }

    public void setLength(short length) {
        this.length = length;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] pack(JSONObject jsonData) throws UnsupportedEncodingException {
        String data = jsonData.toString();
        byte[] dataArray = data.getBytes(DEFAULT_CHARSET);
        ByteBuffer buffer = ByteBuffer.allocate(4 + dataArray.length);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putShort((short)-24142);
        buffer.putShort((short)dataArray.length);
        buffer.put(dataArray);
        this.length = (short)dataArray.length;
        this.data = dataArray;
        return buffer.array();
    }

    public int unpack(byte[] message, int msgLen) throws UnmatchedMagicHeaderException, UncompletePacketException {
        ByteBuffer buffer = ByteBuffer.wrap(message, 0, msgLen);
        buffer.order(ByteOrder.BIG_ENDIAN);
        if (buffer.getShort() != -24142) {
            throw new UnmatchedMagicHeaderException();
        }
        short length = buffer.getShort();
        if (msgLen < 4 + length) {
            throw new UncompletePacketException();
        }
        byte[] dataArray = new byte[length];
        buffer.get(dataArray);
        this.length = length;
        this.data = dataArray;
        return 4 + this.length;
    }

    public JSONObject getJson() throws UnsupportedEncodingException, InvalidMessageFormatException {
        JSONObject jsonData = JSONObject.fromObject((Object)new String(this.data, DEFAULT_CHARSET));
        if (jsonData == null) {
            throw new InvalidMessageFormatException();
        }
        return jsonData;
    }

    public PacketType checkPacket(JSONObject jsonData) throws UnsupportedEncodingException, InvalidMessageFormatException {
        if (jsonData.has("method")) {
            return PacketType.REQUEST;
        }
        if (jsonData.has("error_code")) {
            return PacketType.RESPONSE;
        }
        throw new InvalidMessageFormatException();
    }

    public static class InvalidMessageFormatException
    extends IOException {
        private static final long serialVersionUID = -6991351250737874309L;

        public InvalidMessageFormatException() {
        }

        public InvalidMessageFormatException(String message) {
            super(message);
        }
    }

    public static enum PacketType {
        REQUEST,
        RESPONSE;

    }

    public static class UncompletePacketException
    extends IOException {
        private static final long serialVersionUID = 4494662746321871102L;
    }

    public static class UnmatchedMagicHeaderException
    extends IOException {
        private static final long serialVersionUID = 2104914269846015695L;
    }
}

